#pragma once

class CFlyingCamera
{
private:
	POINT pCur;
	int iForw, iBack, iLeft, iRight;

public:
	vec3 vEye, vView, vUp;
	float fSpeed;
	float fSensitivity;

public:
	CFlyingCamera();
	CFlyingCamera(vec3 a_vEye, vec3 a_vView, vec3 a_vUp, float a_fSpeed, float a_fSensitivity);

	void rotateWithMouse();
	void update();
	mat4 look();
	void setMovingKeys(int a_iForw, int a_iBack, int a_iLeft, int a_iRight);
	void resetMouse();
	float getAngleX();
	float getAngleY();
};

extern CFlyingCamera fcMain;
